<!doctype html>
<html lang="id">
<head>
  <meta charset="utf-8">
  <meta name="viewport" content="width=device-width, initial-scale=1">
  <title><?= esc($title ?? 'Kelola Berita') ?></title>

  <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css" rel="stylesheet">
  <link rel="icon" href="<?= base_url('assets/images/logo1.png') ?>" type="image/png">
  
  <style>
    .sidebar { width: 280px; min-height: 100vh; overflow-y: auto; }
    .sidebar a { text-decoration: none; }
    .sidebar .active { background: rgba(13,110,253,.12); border-radius: .5rem; }
    .sub-menu { padding-left: 1rem; }
    .sub-menu .list-group-item {
      font-size: 0.9rem;
      padding: 0.5rem 1rem;
      border: none;
    }
    .menu-toggle {
      cursor: pointer;
      position: relative;
    }
    .menu-toggle::after {
      content: '▼';
      position: absolute;
      right: 1rem;
      font-size: 0.75rem;
      transition: transform 0.3s;
    }
    .menu-toggle.collapsed::after {
      transform: rotate(-90deg);
    }
    body { background: #f6f8fb; }
    .page-wrap { max-width: 1200px; }
    .hero-title { letter-spacing: .2px; }
    .soft-card {
      border: 0;
      border-radius: 18px;
      box-shadow: 0 10px 30px rgba(16, 24, 40, .08);
    }
    .hint { color: #667085; font-size: .9rem; }
    .main-content { flex: 1; }
    
    .btn-tambah {
      display: inline-flex;
      align-items: center;
      gap: 0.5rem;
      padding: 11px 20px;
      background: #2563eb;
      color: white;
      border-radius: 999px;
      text-decoration: none;
      font-weight: 600;
      font-size: 14px;
      transition: all 0.2s;
    }
    
    .btn-tambah:hover {
      background: #1d4ed8;
      color: white;
      transform: translateY(-1px);
      box-shadow: 0 4px 12px rgba(37, 99, 235, 0.25);
    }
    
    .alert-success {
      background: #d1fae5;
      color: #065f46;
      padding: 14px 16px;
      border-radius: 12px;
      margin-bottom: 24px;
      border: 1px solid #a7f3d0;
      font-size: 14px;
      display: flex;
      align-items: center;
      gap: 8px;
    }
    
    .table-responsive {
      border-radius: 12px;
      overflow: hidden;
    }
    
    .table {
      margin: 0;
    }
    
    .table thead {
      background: #f8f9fa;
      border-bottom: 2px solid #e5e7eb;
    }
    
    .table th {
      padding: 16px;
      font-weight: 600;
      font-size: 14px;
      color: #344054;
      border: none;
    }
    
    .table td {
      padding: 16px;
      font-size: 14px;
      vertical-align: middle;
      border-top: 1px solid #f1f3f5;
    }
    
    .table tbody tr:hover {
      background: #f9fafb;
    }
    
    .img-thumbnail-small {
      width: 70px;
      height: 70px;
      object-fit: cover;
      border-radius: 8px;
      border: 1px solid #e5e7eb;
    }
    
    .no-img {
      width: 70px;
      height: 70px;
      background: #f3f4f6;
      border-radius: 8px;
      display: flex;
      align-items: center;
      justify-content: center;
      color: #9ca3af;
      font-size: 1.5rem;
      border: 1px dashed #d1d5db;
    }
    
    .status-icon {
      font-size: 1.3rem;
    }
    
    .btn-sm-action {
      padding: 7px 14px;
      border-radius: 8px;
      text-decoration: none;
      font-weight: 600;
      font-size: 13px;
      transition: all 0.2s;
      display: inline-block;
      margin-right: 5px;
    }
    
    .btn-edit {
      background: #e0f2fe;
      color: #075985;
    }
    
    .btn-edit:hover {
      background: #bae6fd;
      color: #0c4a6e;
    }
    
    .btn-hapus {
      background: #fee2e2;
      color: #991b1b;
    }
    
    .btn-hapus:hover {
      background: #fecaca;
      color: #7f1d1d;
    }
    
    .empty-row {
      text-align: center;
      padding: 3rem;
      color: #6b7280;
    }
    /* ===== TAMBAHAN RESPONSIVE (AMAN) ===== */
    .hamburger {
      display: none;
      font-size: 1.6rem;
      color: #fff;
      cursor: pointer;
    }

    .sidebar-overlay {
      display: none;
      position: fixed;
      inset: 0;
      background: rgba(0,0,0,.45);
      z-index: 1040;
    }

    @media (max-width: 991px) {
      .hamburger {
        display: block;
      }

      .sidebar {
        position: fixed;
        top: 0;
        left: 0;
        z-index: 1050;
        background: #fff;
        transform: translateX(-100%);
        transition: transform .3s ease;
      }

      .sidebar.show {
        transform: translateX(0);
      }

      .sidebar-overlay.show {
        display: block;
      }
    }
  </style>
</head>

<body class="bg-light">

<nav class="navbar navbar-expand-lg bg-primary navbar-dark">
  <div class="container-fluid">
    <a class="navbar-brand fw-bold" href="<?= site_url('admin') ?>">Welcome back Admin</a>

    <!-- TAMBAHAN: HAMBURGER (TIDAK MENGHAPUS APA PUN) -->
    <span class="hamburger ms-auto me-3" onclick="toggleSidebar()">☰</span>

    <div class="d-flex gap-2 align-items-center">
      <span class="text-white small">Halo, <?= esc(auth()->user()->username ?? 'Admin') ?></span>
      <a class="btn btn-outline-light btn-sm" href="<?= site_url('logout') ?>">Logout</a>
    </div>
  </div>
</nav>

<!-- TAMBAHAN: OVERLAY -->
<div class="sidebar-overlay" onclick="toggleSidebar()"></div>

<div class="d-flex">

  <!-- ===== SIDEBAR ASLI KAMU (UTUH, TIDAK DIHAPUS) ===== -->
  <aside class="sidebar bg-white border-end p-3" id="sidebar">
    <div class="fw-bold mb-2">Admin Panel</div>

    <?php
      $uri = service('uri')->getPath();

      $isInfoSekolahActive = ($uri === 'admin' || $uri === 'admin/' ||
                              str_starts_with($uri, 'admin/branding') ||
                              str_starts_with($uri, 'admin/visi-misi') ||
                              str_starts_with($uri, 'admin/kepsek') ||
                              str_starts_with($uri, 'admin/video-profile') ||
                              str_starts_with($uri, 'admin/data-sekolah') ||
                              str_starts_with($uri, 'admin/footer'));

      $isBeritaActive = (str_starts_with($uri, 'admin/berita') ||
                        str_starts_with($uri, 'admin/pengumuman') ||
                        str_starts_with($uri, 'admin/kelulusan') ||
                        str_starts_with($uri, 'admin/kegiatan') ||
                        str_starts_with($uri, 'admin/prestasi'));

      $isGaleriActive = (str_starts_with($uri, 'admin/galeri') ||
                        str_starts_with($uri, 'admin/guru-staf') ||
                        str_starts_with($uri, 'admin/siswa') ||
                        str_starts_with($uri, 'admin/video') ||
                        str_starts_with($uri, 'admin/ekstrakulikuler'));
    ?>

    <div class="list-group list-group-flush">
      <!-- Informasi Sekolah -->
      <a class="list-group-item list-group-item-action menu-toggle <?= $isInfoSekolahActive ? '' : 'collapsed' ?> <?= ($uri === 'admin' || $uri === 'admin/') ? 'active' : '' ?>"
         data-bs-toggle="collapse"
         href="#infoSekolahMenu"
         role="button"
         aria-expanded="<?= $isInfoSekolahActive ? 'true' : 'false' ?>"
         aria-controls="infoSekolahMenu">
        Informasi Sekolah
      </a>

      <div class="collapse <?= $isInfoSekolahActive ? 'show' : '' ?>" id="infoSekolahMenu">
        <div class="sub-menu">
          <a class="list-group-item list-group-item-action <?= ($uri === 'admin' || $uri === 'admin/') ? 'active' : '' ?>"
             href="<?= site_url('admin') ?>">Dashboard</a>

          <a class="list-group-item list-group-item-action <?= str_starts_with($uri, 'admin/visi-misi') ? 'active' : '' ?>"
             href="<?= site_url('admin/visi-misi') ?>">Visi & Misi</a>

          <a class="list-group-item list-group-item-action <?= str_starts_with($uri, 'admin/kepsek') ? 'active' : '' ?>"
             href="<?= site_url('admin/kepsek') ?>">Kata Sambutan</a>

          <a class="list-group-item list-group-item-action <?= str_starts_with($uri, 'admin/video-profile') ? 'active' : '' ?>"
             href="<?= site_url('admin/video-profile') ?>">Video Profile</a>

          <a class="list-group-item list-group-item-action <?= str_starts_with($uri, 'admin/data-sekolah') ? 'active' : '' ?>"
             href="<?= site_url('admin/data-sekolah') ?>">Statistika</a>

             <a class="list-group-item list-group-item-action <?= str_starts_with($uri, 'admin/footer') ? 'active' : '' ?>"
             href="<?= site_url('admin/footer') ?>">Footer</a>
        </div>
      </div>

      <!-- Berita -->
      <a class="list-group-item list-group-item-action menu-toggle <?= $isBeritaActive ? '' : 'collapsed' ?>"
         data-bs-toggle="collapse"
         href="#beritaMenu"
         role="button"
         aria-expanded="<?= $isBeritaActive ? 'true' : 'false' ?>"
         aria-controls="beritaMenu">
        Berita
      </a>

      <div class="collapse <?= $isBeritaActive ? 'show' : '' ?>" id="beritaMenu">
        <div class="sub-menu">
          <a class="list-group-item list-group-item-action <?= str_starts_with($uri, 'admin/pengumuman') ? 'active' : '' ?>"
             href="<?= site_url('admin/pengumuman') ?>">Pengumuman</a>

          <a class="list-group-item list-group-item-action <?= str_starts_with($uri, 'admin/kelulusan') ? 'active' : '' ?>"
             href="<?= site_url('admin/kelulusan') ?>">Pengumuman Kelulusan</a>

          <a class="list-group-item list-group-item-action <?= str_starts_with($uri, 'admin/kegiatan') ? 'active' : '' ?>"
             href="<?= site_url('admin/kegiatan') ?>">Kegiatan</a>

          <a class="list-group-item list-group-item-action <?= str_starts_with($uri, 'admin/prestasi') ? 'active' : '' ?>"
             href="<?= site_url('admin/prestasi') ?>">Prestasi</a>
        </div>
      </div>

      <!-- Galeri -->
      <a class="list-group-item list-group-item-action menu-toggle <?= $isGaleriActive ? '' : 'collapsed' ?>"
         data-bs-toggle="collapse"
         href="#galeriMenu"
         role="button"
         aria-expanded="<?= $isGaleriActive ? 'true' : 'false' ?>"
         aria-controls="galeriMenu">
        Galeri
      </a>

      <div class="collapse <?= $isGaleriActive ? 'show' : '' ?>" id="galeriMenu">
        <div class="sub-menu">
          <a class="list-group-item list-group-item-action <?= str_starts_with($uri, 'admin/guru-staf') ? 'active' : '' ?>"
             href="<?= site_url('admin/guru-staf') ?>">Guru dan Staf</a>

          <a class="list-group-item list-group-item-action <?= str_starts_with($uri, 'admin/siswa') ? 'active' : '' ?>"
             href="<?= site_url('admin/siswa') ?>">Siswa/Siswi</a>

          <a class="list-group-item list-group-item-action <?= str_starts_with($uri, 'admin/video') ? 'active' : '' ?>"
             href="<?= site_url('admin/video') ?>">Video</a>

          <a class="list-group-item list-group-item-action <?= str_starts_with($uri, 'admin/ekstrakurikuler') ? 'active' : '' ?>"
             href="<?= site_url('admin/ekstrakurikuler') ?>">Ekstrakulikuler</a>
        </div>
      </div>

      <a class="list-group-item list-group-item-action <?= str_starts_with($uri, 'admin/tentang') ? 'active' : '' ?>"
         href="<?= site_url('admin/tentang') ?>">Tentang</a>

      <a class="list-group-item list-group-item-action <?= str_starts_with($uri, 'admin/password') ? 'active' : '' ?>"
         href="<?= site_url('admin/password') ?>">Ubah Password</a>
    </div>
  </aside>



  <div class="main-content">
    <div class="container py-4 page-wrap">

      <div class="d-flex flex-column flex-md-row align-items-md-center justify-content-between gap-3 mb-4">
        <div>
          <h1 class="h3 mb-1 hero-title"><?= esc($title ?? 'Kelola Berita') ?></h1>
          <div class="hint">Kelola semua berita yang ditampilkan di website.</div>
        </div>
        <div>
          <a href="<?= site_url('admin/pengumuman/create') ?>" class="btn-tambah">
            + Tambah Berita
          </a>
        </div>
      </div>

      <?php if (session()->getFlashdata('success')): ?>
        <div class="alert-success">
          <div>✅</div>
          <div><?= session()->getFlashdata('success') ?></div>
        </div>
      <?php endif; ?>

      <div class="card soft-card">
        <div class="card-body p-0">
          <div class="table-responsive">
            <table class="table">
              <thead>
                <tr>
                  <th>Judul</th>
                  <th style="width: 100px; text-align: center;">Gambar</th>
                  <th style="width: 80px; text-align: center;">Status</th>
                  <th style="width: 120px;">Tanggal</th>
                  <th style="width: 160px; text-align: center;">Aksi</th>
                </tr>
              </thead>
              <tbody>
                <?php if (empty($items)): ?>
                  <tr>
                    <td colspan="5" class="empty-row">
                      Belum ada data berita.
                    </td>
                  </tr>
                <?php else: ?>
                  <?php foreach ($items as $row): ?>
                    <tr>
                      <td>
                        <div style="font-weight: 600; color: #1f2937;">
                          <?= esc($row['judul']) ?>
                        </div>
                      </td>

                      <td style="text-align: center;">
                        <?php if (!empty($row['gambar'])): ?>
                          <img src="<?= base_url('uploads/berita/' . $row['gambar']) ?>" class="img-thumbnail-small">
                        <?php else: ?>
                          <div class="no-img">—</div>
                        <?php endif; ?>
                      </td>

                      <td style="text-align: center;">
                        <span class="status-icon">
                          <?= $row['is_published'] ? '✓' : '✗' ?>
                        </span>
                      </td>

                      <td>
                        <?= $row['tanggal_publish'] ? date('d M Y', strtotime($row['tanggal_publish'])) : '-' ?>
                      </td>

                      <td style="text-align: center;">
                        <a href="<?= site_url('admin/pengumuman/edit/' . $row['id']) ?>" class="btn-sm-action btn-edit">
                          Edit
                        </a>
                        <a href="<?= site_url('admin/pengumuman/delete/' . $row['id']) ?>" 
                           class="btn-sm-action btn-hapus"
                           onclick="return confirm('Yakin hapus berita ini?')">
                          Hapus
                        </a>
                      </td>
                    </tr>
                  <?php endforeach; ?>
                <?php endif; ?>
              </tbody>
            </table>
          </div>
        </div>
      </div>

      <?php if (!empty($items)): ?>
        <div class="mt-3">
          <?= $pager->links() ?>
        </div>
      <?php endif; ?>

      <div class="hint text-center mt-4">
        © <?= date('Y') ?> Admin Panel
      </div>

    </div>
  </div>
</div>

<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/js/bootstrap.bundle.min.js"></script>
<!-- ===== TAMBAHAN JS (AMAN) ===== -->
<script>
function toggleSidebar(){
  document.getElementById('sidebar').classList.toggle('show');
  document.querySelector('.sidebar-overlay').classList.toggle('show');
}
</script>
</body>
</html>